<?php
// Create App (Upload)
$input = $_POST; // Use $_POST for form-data, getInput() deals with raw JSON

// Check if request exceeded post_max_size
if (empty($_POST) && $_SERVER['CONTENT_LENGTH'] > 0) {
    sendResponse(['error' => 'Request too large (post_max_size exceeded). Please check PHP settings.'], 400);
}

if (!isset($input['console_id']) || !isset($input['app_name'])) {
    sendResponse(['error' => 'Missing required fields (console_id, app_name)'], 400);
}

$conn = getDBConnection();

// Verify Console exists
$stmt = $conn->prepare("SELECT id FROM consoles WHERE id = ?");
$stmt->execute([$input['console_id']]);
if (!$stmt->fetch()) {
    sendResponse(['error' => 'Console not found'], 404);
}

// File Upload Handling
$uploadDir = __DIR__ . '/../../storage/';
$appCodePath = null;
$jksPath = null;

if (isset($_FILES['app_code_zip'])) {
    if ($_FILES['app_code_zip']['error'] !== 0) {
        $uploadErrors = [
            1 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini',
            2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
            3 => 'The uploaded file was only partially uploaded',
            4 => 'No file was uploaded',
            6 => 'Missing a temporary folder',
            7 => 'Failed to write file to disk',
            8 => 'A PHP extension stopped the file upload'
        ];
        $errorCode = $_FILES['app_code_zip']['error'];
        $errorMessage = isset($uploadErrors[$errorCode]) ? $uploadErrors[$errorCode] : 'Unknown upload error';
        sendResponse(['error' => 'App code ZIP upload error: ' . $errorMessage], 400);
    }

    if (pathinfo($_FILES['app_code_zip']['name'], PATHINFO_EXTENSION) !== 'zip') {
        sendResponse(['error' => 'App code must be a ZIP file'], 400);
    }
    $filename = uniqid() . '_' . basename($_FILES['app_code_zip']['name']);
    $target = $uploadDir . 'app_codes/' . $filename;
    if (move_uploaded_file($_FILES['app_code_zip']['tmp_name'], $target)) {
        $appCodePath = 'storage/app_codes/' . $filename;
    } else {
        sendResponse(['error' => 'Failed to upload app code ZIP to storage'], 500);
    }
}

if (isset($_FILES['jks_file'])) {
    if ($_FILES['jks_file']['error'] !== 0) {
        $errorCode = $_FILES['jks_file']['error'];
        // skip if no file uploaded (optional field?) - actually user might want to upload one. 
        // If it's explicitly sent but has error, report it.
        if ($errorCode !== 4) { // 4 = UPLOAD_ERR_NO_FILE
             sendResponse(['error' => 'JKS file upload error code: ' . $errorCode], 400);
        }
    } else {
        $filename = uniqid() . '_' . basename($_FILES['jks_file']['name']);
        $target = $uploadDir . 'jks/' . $filename;
        if (move_uploaded_file($_FILES['jks_file']['tmp_name'], $target)) {
            $jksPath = 'storage/jks/' . $filename;
        } else {
            sendResponse(['error' => 'Failed to upload JKS file to storage'], 500);
        }
    }
}

try {
    $stmt = $conn->prepare("INSERT INTO apps (console_id, app_name, app_link, app_code_zip_path, jks_file_path, jks_alias, jks_password, status) VALUES (?, ?, ?, ?, ?, ?, ?, 'uploaded')");
    $stmt->execute([
        $input['console_id'],
        $input['app_name'],
        isset($input['app_link']) ? $input['app_link'] : null,
        $appCodePath,
        $jksPath,
        isset($input['jks_alias']) ? $input['jks_alias'] : null,
        isset($input['jks_password']) ? $input['jks_password'] : null
    ]);

    $appId = $conn->lastInsertId();

    // Update Console Status
    updateConsoleStatus($input['console_id'], $conn);

    logActivity($conn, authenticate()['user_id'], 'created_app', 'app', $appId);

    sendResponse(['message' => 'App created successfully', 'id' => $appId], 201);
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to create app: ' . $e->getMessage()], 500);
}
?>
