<?php
// Delete App
if (!$id) {
    sendResponse(['error' => 'App ID is required'], 400);
}

$conn = getDBConnection();

try {
    // Get file paths to delete
    $stmt = $conn->prepare("SELECT console_id, app_code_zip_path, jks_file_path FROM apps WHERE id = ?");
    $stmt->execute([$id]);
    $app = $stmt->fetch();
    
    if (!$app) {
        sendResponse(['error' => 'App not found'], 404);
    }

    $stmt = $conn->prepare("DELETE FROM apps WHERE id = ?");
    $stmt->execute([$id]);

    // Delete files
    if ($app['app_code_zip_path'] && file_exists(__DIR__ . '/../../' . $app['app_code_zip_path'])) {
        unlink(__DIR__ . '/../../' . $app['app_code_zip_path']);
    }
    if ($app['jks_file_path'] && file_exists(__DIR__ . '/../../' . $app['jks_file_path'])) {
        unlink(__DIR__ . '/../../' . $app['jks_file_path']);
    }

    // Update Console Status
    updateConsoleStatus($app['console_id'], $conn);

    logActivity($conn, authenticate()['user_id'], 'deleted_app', 'app', $id);

    sendResponse(['message' => 'App deleted successfully']);
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to delete app: ' . $e->getMessage()], 500);
}
?>
