<?php
// Download App ZIP
if (!$id) {
    sendResponse(['error' => 'App ID is required'], 400);
}

$conn = getDBConnection();

$stmt = $conn->prepare("SELECT * FROM apps WHERE id = ?");
$stmt->execute([$id]);
$app = $stmt->fetch();

if (!$app) {
    sendResponse(['error' => 'App not found'], 404);
}

$baseDir = __DIR__ . '/../../';
$appCodePath = $baseDir . $app['app_code_zip_path'];
$jksPath = $baseDir . $app['jks_file_path'];

if (!file_exists($appCodePath) || !file_exists($jksPath)) {
    sendResponse(['error' => 'One or more source files not found'], 404);
}

// Create ZIP
$zip = new ZipArchive();
$zipFilename = 'bundle_' . $app['id'] . '_' . uniqid() . '.zip';
$zipPath = $baseDir . 'storage/temp/' . $zipFilename;

// Ensure temp dir exists
if (!is_dir($baseDir . 'storage/temp/')) {
    mkdir($baseDir . 'storage/temp/', 0777, true);
}

if ($zip->open($zipPath, ZipArchive::CREATE) !== TRUE) {
    sendResponse(['error' => 'Failed to create ZIP archive'], 500);
}

// Add app code
$zip->addFile($appCodePath, 'app_code.zip');

// Add JKS
$zip->addFile($jksPath, 'keystore.jks');

// Add credentials.txt
$credentialsContent = "Key Alias: " . $app['jks_alias'] . "\n";
$credentialsContent .= "Key Password: " . $app['jks_password'] . "\n";
$zip->addFromString('credentials.txt', $credentialsContent);

$zip->close();

// Stream Download
if (file_exists($zipPath)) {
    header('Content-Description: File Transfer');
    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="'.basename($zipFilename).'"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($zipPath));
    
    logActivity($conn, authenticate()['user_id'], 'downloaded_zip', 'app', $id);

    readfile($zipPath);
    
    // Delete after download
    unlink($zipPath);
    exit;
} else {
    sendResponse(['error' => 'Failed to generate ZIP file'], 500);
}
?>
