<?php
// List Apps
$conn = getDBConnection();

$console_id = isset($_GET['console_id']) ? $_GET['console_id'] : null;

try {
    if ($id) {
        $stmt = $conn->prepare("SELECT * FROM apps WHERE id = ?");
        $stmt->execute([$id]);
        $app = $stmt->fetch();
        if ($app) {
            sendResponse($app);
        } else {
            sendResponse(['error' => 'App not found'], 404);
        }
    } elseif ($console_id) {
        $stmt = $conn->prepare("SELECT * FROM apps WHERE console_id = ? ORDER BY id DESC");
        $stmt->execute([$console_id]);
        $apps = $stmt->fetchAll();
        sendResponse($apps);
    } else {
        $stmt = $conn->query("SELECT * FROM apps ORDER BY id DESC");
        $apps = $stmt->fetchAll();
        sendResponse($apps);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch apps: ' . $e->getMessage()], 500);
}
?>
