<?php
// Update App
if (!$id) {
    sendResponse(['error' => 'App ID is required'], 400);
}

// Supports both JSON (for status/text updates) and POST (if re-uploading files - though typically split, but we'll stick to JSON for status updates as per simple crud, or POST for files. Let's assume JSON for now for fields, but PHP doesn't parse multipart PUT easily. 
// For simplicity, we'll use getInput() for fields. Re-uploading files might require a separate endpoint or POST override, but requirements emphasize "Update app status". Let's focus on fields.

$input = getInput();
if (!$input) {
    // try post if input is empty/form-data
    $input = $_POST;
}

if (!$input && empty($_FILES)) {
    sendResponse(['error' => 'No data provided'], 400);
}

$conn = getDBConnection();

// Get current app to know console_id
$stmt = $conn->prepare("SELECT console_id, app_code_zip_path, jks_file_path FROM apps WHERE id = ?");
$stmt->execute([$id]);
$currentApp = $stmt->fetch();
if (!$currentApp) {
    sendResponse(['error' => 'App not found'], 404);
}

$fields = [];
$params = [];

if (isset($input['app_name'])) { $fields[] = "app_name = ?"; $params[] = $input['app_name']; }
if (isset($input['app_link'])) { $fields[] = "app_link = ?"; $params[] = $input['app_link']; }
if (isset($input['jks_alias'])) { $fields[] = "jks_alias = ?"; $params[] = $input['jks_alias']; }
if (isset($input['jks_password'])) { $fields[] = "jks_password = ?"; $params[] = $input['jks_password']; }
if (isset($input['status'])) { 
    $allowedStatuses = ['uploaded', 'in_review', 'published', 'rejected'];
    if (!in_array($input['status'], $allowedStatuses)) {
        sendResponse(['error' => 'Invalid status'], 400);
    }
    $fields[] = "status = ?"; 
    $params[] = $input['status']; 
}

// Handle File Updates (optional but good to have)
$uploadDir = __DIR__ . '/../../storage/';
if (isset($_FILES['app_code_zip']) && $_FILES['app_code_zip']['error'] == 0) {
    if (pathinfo($_FILES['app_code_zip']['name'], PATHINFO_EXTENSION) !== 'zip') {
        sendResponse(['error' => 'App code must be a ZIP file'], 400);
    }
    // Delete old file
    if ($currentApp['app_code_zip_path'] && file_exists(__DIR__ . '/../../' . $currentApp['app_code_zip_path'])) {
        unlink(__DIR__ . '/../../' . $currentApp['app_code_zip_path']);
    }
    $filename = uniqid() . '_' . basename($_FILES['app_code_zip']['name']);
    $target = $uploadDir . 'app_codes/' . $filename;
    move_uploaded_file($_FILES['app_code_zip']['tmp_name'], $target);
    $fields[] = "app_code_zip_path = ?";
    $params[] = 'storage/app_codes/' . $filename;
}

if (isset($_FILES['jks_file']) && $_FILES['jks_file']['error'] == 0) {
    // Delete old file
    if ($currentApp['jks_file_path'] && file_exists(__DIR__ . '/../../' . $currentApp['jks_file_path'])) {
        unlink(__DIR__ . '/../../' . $currentApp['jks_file_path']);
    }
    $filename = uniqid() . '_' . basename($_FILES['jks_file']['name']);
    $target = $uploadDir . 'jks/' . $filename;
    move_uploaded_file($_FILES['jks_file']['tmp_name'], $target);
    $fields[] = "jks_file_path = ?";
    $params[] = 'storage/jks/' . $filename;
}


if (empty($fields)) {
    sendResponse(['message' => 'No changes made']);
}

$params[] = $id;

try {
    $sql = "UPDATE apps SET " . implode(", ", $fields) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    if (isset($input['status'])) {
        updateConsoleStatus($currentApp['console_id'], $conn);
        logActivity($conn, authenticate()['user_id'], 'updated_app_status', 'app', $id);
    } else {
        logActivity($conn, authenticate()['user_id'], 'updated_app', 'app', $id);
    }

    sendResponse(['message' => 'App updated successfully']);
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to update app: ' . $e->getMessage()], 500);
}
?>
