<?php
// List Audit Logs
$conn = getDBConnection();

$admin_id = isset($_GET['admin_id']) ? $_GET['admin_id'] : null;
$model_type = isset($_GET['model_type']) ? $_GET['model_type'] : null;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 100;
$limit = min($limit, 1000); // Cap limit

try {
    // activity_logs is aliased as l
    $sql = "SELECT l.*, a.name as admin_name FROM activity_logs l LEFT JOIN admins a ON l.admin_id = a.id";
    $conditions = [];
    $params = [];

    if ($admin_id) {
        $conditions[] = "l.admin_id = ?";
        $params[] = $admin_id;
    }
    if ($model_type) {
        $conditions[] = "l.model_type = ?";
        $params[] = $model_type;
    }
    
    // New Filters
    $action = isset($_GET['action']) ? $_GET['action'] : null;
    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : null;

    if ($action) {
        $conditions[] = "l.action = ?";
        $params[] = $action;
    }
    if ($start_date) {
        $conditions[] = "l.created_at >= ?";
        $params[] = $start_date . ' 00:00:00';
    }
    if ($end_date) {
        $conditions[] = "l.created_at <= ?";
        $params[] = $end_date . ' 23:59:59';
    }

    if (!empty($conditions)) {
        $sql .= " WHERE " . implode(" AND ", $conditions);
    }

    $sql .= " ORDER BY l.id DESC LIMIT $limit";

    $stmt = $conn->prepare($sql);
    $stmt->execute($params);
    $logs = $stmt->fetchAll();
    
    sendResponse($logs);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch audit logs: ' . $e->getMessage()], 500);
}
?>
