<?php
// Login Admin
$input = getInput();

if (!isset($input['email']) || !isset($input['password'])) {
    sendResponse(['error' => 'Missing required fields (email, password)'], 400);
}

$conn = getDBConnection();

$stmt = $conn->prepare("SELECT id, name, password_hash FROM admins WHERE email = ?");
$stmt->execute([$input['email']]);
$user = $stmt->fetch();

if ($user && password_verify($input['password'], $user['password_hash'])) {
    $payload = [
        'user_id' => $user['id'],
        'name' => $user['name'],
        'email' => $input['email'],
        'iat' => time(),
        'exp' => time() + (60 * 60 * 24) // 24 hours expiry
    ];
    
    $token = JWT::encode($payload);
    
    sendResponse(['token' => $token, 'user' => ['id' => $user['id'], 'name' => $user['name']]]);
} else {
    sendResponse(['error' => 'Invalid credentials'], 401);
}
?>
