<?php
// Register Admin
$input = getInput();

if (!isset($input['name']) || !isset($input['email']) || !isset($input['password'])) {
    sendResponse(['error' => 'Missing required fields (name, email, password)'], 400);
}

$conn = getDBConnection();

// Check if email already exists
$stmt = $conn->prepare("SELECT id FROM admins WHERE email = ?");
$stmt->execute([$input['email']]);
if ($stmt->fetch()) {
    sendResponse(['error' => 'Email already exists'], 409);
}

$passwordHash = password_hash($input['password'], PASSWORD_BCRYPT);

try {
    $stmt = $conn->prepare("INSERT INTO admins (name, email, password_hash) VALUES (?, ?, ?)");
    $stmt->execute([$input['name'], $input['email'], $passwordHash]);
    sendResponse(['message' => 'Admin registered successfully'], 201);
} catch (Exception $e) {
    sendResponse(['error' => 'Registration failed: ' . $e->getMessage()], 500);
}
?>
