<?php
// Create Browser
$input = getInput();

if (!isset($input['rdp_id']) || !isset($input['browser_name'])) {
    sendResponse(['error' => 'Missing required fields (rdp_id, browser_name)'], 400);
}

$conn = getDBConnection();

// Verify RDP exists
$stmt = $conn->prepare("SELECT id FROM rdps WHERE id = ?");
$stmt->execute([$input['rdp_id']]);
if (!$stmt->fetch()) {
    sendResponse(['error' => 'RDP not found'], 404);
}

try {
    $stmt = $conn->prepare("INSERT INTO browsers (rdp_id, browser_name) VALUES (?, ?)");
    $stmt->execute([$input['rdp_id'], $input['browser_name']]);
    $browserId = $conn->lastInsertId();
    logActivity($conn, authenticate()['user_id'], 'created_browser', 'browser', $browserId);
    sendResponse(['message' => 'Browser added successfully', 'id' => $browserId], 201);
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to add browser: ' . $e->getMessage()], 500);
}
?>
