<?php
// Delete Browser
if (!$id) {
    sendResponse(['error' => 'Browser ID is required'], 400);
}

$conn = getDBConnection();

try {
    $stmt = $conn->prepare("DELETE FROM browsers WHERE id = ?");
    $stmt->execute([$id]);

    if ($stmt->rowCount() > 0) {
        logActivity($conn, authenticate()['user_id'], 'deleted_browser', 'browser', $id);
        sendResponse(['message' => 'Browser deleted successfully']);
    } else {
        sendResponse(['error' => 'Browser not found'], 404);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to delete browser: ' . $e->getMessage()], 500);
}
?>
