<?php
// List Browsers
$conn = getDBConnection();

// Filter by rdp_id if provided as query param ?rdp_id=
$rdp_id = isset($_GET['rdp_id']) ? $_GET['rdp_id'] : null;

try {
    if ($id) {
        // Get specific browser
        $stmt = $conn->prepare("SELECT b.*, c.console_name 
                                FROM browsers b 
                                LEFT JOIN email_accounts e ON e.browser_id = b.id 
                                LEFT JOIN consoles c ON c.email_id = e.id 
                                WHERE b.id = ?");
        $stmt->execute([$id]);
        $browser = $stmt->fetch();
        if ($browser) {
            sendResponse($browser);
        } else {
            sendResponse(['error' => 'Browser not found'], 404);
        }
    } elseif ($rdp_id) {
        // List by RDP
        $stmt = $conn->prepare("SELECT b.*, c.console_name 
                                FROM browsers b 
                                LEFT JOIN email_accounts e ON e.browser_id = b.id 
                                LEFT JOIN consoles c ON c.email_id = e.id 
                                WHERE b.rdp_id = ? 
                                AND (c.status IS NULL OR c.status != 'terminated')
                                ORDER BY b.id DESC");
        $stmt->execute([$rdp_id]);
        $browsers = $stmt->fetchAll();
        sendResponse($browsers);
    } else {
        // List all
        $stmt = $conn->query("SELECT b.*, c.console_name 
                              FROM browsers b 
                              LEFT JOIN email_accounts e ON e.browser_id = b.id 
                              LEFT JOIN consoles c ON c.email_id = e.id 
                              WHERE (c.status IS NULL OR c.status != 'terminated')
                              ORDER BY b.id DESC");
        $browsers = $stmt->fetchAll();
        sendResponse($browsers);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch browsers: ' . $e->getMessage()], 500);
}
?>
