<?php
// Update Browser
if (!$id) {
    sendResponse(['error' => 'Browser ID is required'], 400);
}

$input = getInput();
if (!$input) {
    sendResponse(['error' => 'No data provided'], 400);
}

$conn = getDBConnection();

$fields = [];
$params = [];

if (isset($input['browser_name'])) {
    $fields[] = "browser_name = ?";
    $params[] = $input['browser_name'];
}
// Optionally allow moving to another RDP? user didn't specify, but let's allow it just in case
if (isset($input['rdp_id'])) {
    $fields[] = "rdp_id = ?";
    $params[] = $input['rdp_id'];
}

if (empty($fields)) {
    sendResponse(['error' => 'No fields to update'], 400);
}

$params[] = $id;

try {
    $sql = "UPDATE browsers SET " . implode(", ", $fields) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    if ($stmt->rowCount() > 0) {
        logActivity($conn, authenticate()['user_id'], 'updated_browser', 'browser', $id);
        sendResponse(['message' => 'Browser updated successfully']);
    } else {
        sendResponse(['message' => 'No changes made or Browser not found']);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to update browser: ' . $e->getMessage()], 500);
}
?>
