<?php
// Check Console

$conn = getDBConnection();
$user = authenticate();
$adminId = $user['user_id'];

// $consoleId set in routes.php

if (!$consoleId) {
    sendResponse(['error' => 'Console ID required'], 400);
}

try {
    // Verify console exists
    $stmt = $conn->prepare("SELECT id FROM consoles WHERE id = ?");
    $stmt->execute([$consoleId]);
    if ($stmt->rowCount() == 0) {
        sendResponse(['error' => 'Console not found'], 404);
    }

    // Update check status
    $sql = "UPDATE consoles SET last_check_at = NOW(), last_check_by = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$adminId, $consoleId]);

    // Log Activity
    logActivity($conn, $adminId, 'checked_console', 'console', $consoleId);

    sendResponse(['message' => 'Console checked successfully']);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to check console: ' . $e->getMessage()], 500);
}
?>
