<?php
// List Consoles
$conn = getDBConnection();

$email_id = isset($_GET['email_id']) ? $_GET['email_id'] : null;

try {
    if ($id) {
        $stmt = $conn->prepare("SELECT c.*, e.email, e.has_new_mail, a.name as last_checked_by_name, DATEDIFF(NOW(), c.created_at) as days_active FROM consoles c JOIN email_accounts e ON c.email_id = e.id LEFT JOIN admins a ON c.last_check_by = a.id WHERE c.id = ?");
        $stmt->execute([$id]);
        $console = $stmt->fetch();
        if ($console) {
            $statusColors = [
                'terminated' => 'red',
                'sold' => 'green',
                'ready' => 'green',
                'review' => 'yellow',
                'document_pending' => 'yellow',
                'document_review' => 'yellow'
            ];
            $console['status_color'] = $statusColors[$console['status']] ?? 'gray';
            sendResponse($console);
        } else {
            sendResponse(['error' => 'Console not found'], 404);
        }
    } elseif ($email_id) {
        $stmt = $conn->prepare("SELECT c.*, e.email, e.has_new_mail, a.name as last_checked_by_name, DATEDIFF(NOW(), c.created_at) as days_active FROM consoles c JOIN email_accounts e ON c.email_id = e.id LEFT JOIN admins a ON c.last_check_by = a.id WHERE c.email_id = ?");
        $stmt->execute([$email_id]);
        $console = $stmt->fetch();
        if ($console) {
            $statusColors = [
                'terminated' => 'red',
                'sold' => 'green',
                'ready' => 'green',
                'review' => 'yellow',
                'document_pending' => 'yellow',
                'document_review' => 'yellow'
            ];
            $console['status_color'] = $statusColors[$console['status']] ?? 'gray';
            sendResponse($console);
        } else {
            sendResponse(['error' => 'Console not found for this email'], 404);
        }
    } else {
        // Advanced Search & Sorting
        $search = isset($_GET['search']) ? trim($_GET['search']) : null;
        $sort = isset($_GET['sort']) ? $_GET['sort'] : 'newest';
        
        $sql = "SELECT DISTINCT c.*, e.email, e.has_new_mail, a.name as last_checked_by_name, 
                DATEDIFF(NOW(), c.created_at) as days_active 
                FROM consoles c 
                JOIN email_accounts e ON c.email_id = e.id 
                LEFT JOIN admins a ON c.last_check_by = a.id 
                LEFT JOIN apps ap ON c.id = ap.console_id";
        
        $conditions = [];
        $params = [];

        if ($search) {
            $conditions[] = "(e.email LIKE ? OR ap.app_name LIKE ? OR c.console_name LIKE ?)";
            $params[] = "%$search%";
            $params[] = "%$search%";
            $params[] = "%$search%";
        }

        if (!empty($conditions)) {
            $sql .= " WHERE " . implode(" AND ", $conditions);
        }

        // Sorting
        if ($sort == 'oldest') {
            $sql .= " ORDER BY c.created_at ASC";
        } else {
            $sql .= " ORDER BY c.created_at DESC";
        }

        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $consoles = $stmt->fetchAll(PDO::FETCH_ASSOC); // Fetch Assoc to avoid duplicate numeric keys
        
        $statusColors = [
            'terminated' => 'red',
            'sold' => 'green',
            'ready' => 'green',
            'review' => 'yellow',
            'document_pending' => 'yellow',
            'document_review' => 'yellow'
        ];

        foreach ($consoles as &$console) {
            $console['status_color'] = $statusColors[$console['status']] ?? 'gray';
        }

        sendResponse($consoles);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch consoles: ' . $e->getMessage()], 500);
}
?>
