<?php
// Console Routes

authenticate();

$requestMethod = $_SERVER['REQUEST_METHOD'];

if ($requestMethod == 'GET') {
    require 'read.php';
} elseif ($requestMethod == 'POST') {
    // Check if the action is 'check'
    // URL structure: /console/{id}/check -> $uri[3] is 'check' (Assuming index.php parses URI)
    // Actually, based on index.php:
    // $uri = explode('/', parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    // The id is likely passed differently or part of the route logic not fully visible here. 
    // In index.php:
    // $resource = isset($uri[2]) ? $uri[2] : null;
    // $id = isset($uri[3]) ? $uri[3] : null;

    // Let's assume we use a query param action=check or check the ID/action structure
    // Since index.php passes control here:
    // If we want /console/{id}/check
    // $uri[2] = 'console'
    // $uri[3] = {id}
    // $uri[4] = 'check' <--- This needs to be handled.
    
    // Check if ID is set
    $consoleId = isset($id) ? $id : null;
    $action = isset($uri[4]) ? $uri[4] : null;
    
    // Alternatively, maybe simpler: POST /console/check with body {id: 1} or POST /console?action=check&id=1
    // But RESTful is POST /console/{id}/check
    
    // Let's rely on $uri global if available or re-parse
    $uri_parts = explode('/', parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
    // /public/api/console/1/check
    // 0 / 1 public / 2 api / 3 console / 4 {id} / 5 check
    
    // Adjusting index based on actual URL structure, verifying with index.php content if needed.
    // Assuming standard layout:
    $actionSegment = isset($uri_parts[5]) ? $uri_parts[5] : null;
    
    if ($actionSegment == 'check') {
        require 'check.php';
    } else {
         header("HTTP/1.1 404 Not Found");
         echo json_encode(['error' => 'Endpoint not found']);
    }

} elseif ($requestMethod == 'PUT') {
    // PUT /console/{id}
    // Expected to update status
    $consoleId = isset($id) ? $id : null;
    if ($consoleId) {
        require 'update.php';
    } else {
         header("HTTP/1.1 400 Bad Request");
         echo json_encode(['error' => 'Console ID required']);
    }

} else {
    header("HTTP/1.1 405 Method Not Allowed");
    echo json_encode(['error' => 'Method not allowed']);
}
?>
