<?php
// Update Console (Status or Name)
$conn = getDBConnection();
$input = getInput();

// consoleId from routes

if (!$consoleId) {
    sendResponse(['error' => 'Console ID required'], 400);
}

try {
    $conn->beginTransaction();

    // 1. Check for Sold logic (Archiving)
    if (isset($input['status']) && $input['status'] === 'sold') {
        // Fetch all related data before cleanup
        $sql = "SELECT c.*, e.email, e.browser_id, b.browser_name, b.rdp_id, r.ip_address 
                FROM consoles c
                JOIN email_accounts e ON c.email_id = e.id
                JOIN browsers b ON e.browser_id = b.id
                JOIN rdps r ON b.rdp_id = r.id
                WHERE c.id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$consoleId]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$data) {
            throw new Exception("Console data not found for archiving.");
        }

        // Fetch associated apps for the snapshot
        $stmt = $conn->prepare("SELECT * FROM apps WHERE console_id = ?");
        $stmt->execute([$consoleId]);
        $apps = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $data['apps_snapshot'] = $apps;

        // Save to sold_consoles archive
        $stmt = $conn->prepare("INSERT INTO sold_consoles (console_id, email, rdp_ip, browser_name, snapshot_json, admin_id) VALUES (?, ?, ?, ?, ?, ?)");
        $adminId = authenticate()['user_id'];
        $stmt->execute([
            $consoleId,
            $data['email'],
            $data['ip_address'],
            $data['browser_name'],
            json_encode($data),
            $adminId
        ]);

        // Cleanup: Delete the Browser (Cascades to Email, Console, App)
        $stmt = $conn->prepare("DELETE FROM browsers WHERE id = ?");
        $stmt->execute([$data['browser_id']]);

        logActivity($conn, $adminId, 'archived_sold_console', 'console', $consoleId);
        
        $conn->commit();
        sendResponse(['message' => 'Console marked as sold, archived, and browser cleanup completed.']);
        exit;
    }

    // 2. Normal update logic
    $fields = [];
    $params = [];

    if (isset($input['status'])) {
        $allowedStatuses = ['review', 'ready', 'terminated', 'document_pending', 'document_review'];
        if (!in_array($input['status'], $allowedStatuses)) {
            sendResponse(['error' => 'Invalid status'], 400);
        }
        $fields[] = "status = ?";
        $params[] = $input['status'];
    }

    if (isset($input['console_name'])) {
        $fields[] = "console_name = ?";
        $params[] = $input['console_name'];
    }

    if (isset($input['created_at'])) {
        $fields[] = "created_at = ?";
        $params[] = $input['created_at'];
    }

    if (empty($fields)) {
        sendResponse(['error' => 'No fields to update (status, console_name, or created_at)'], 400);
    }

    $params[] = $consoleId;
    $sql = "UPDATE consoles SET " . implode(", ", $fields) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    $adminId = authenticate()['user_id'];
    logActivity($conn, $adminId, 'updated_console', 'console', $consoleId);

    $conn->commit();
    sendResponse(['message' => 'Console updated successfully']);

} catch (Exception $e) {
    if ($conn->inTransaction()) {
        $conn->rollBack();
    }
    sendResponse(['error' => 'Failed to update console: ' . $e->getMessage()], 500);
}
?>
