<?php
// Create Email Account
$input = getInput();

if (!isset($input['browser_id']) || !isset($input['email']) || !isset($input['email_password'])) {
    sendResponse(['error' => 'Missing required fields (browser_id, email, email_password)'], 400);
}

$conn = getDBConnection();

// Verify Browser exists
$stmt = $conn->prepare("SELECT id FROM browsers WHERE id = ?");
$stmt->execute([$input['browser_id']]);
if (!$stmt->fetch()) {
    sendResponse(['error' => 'Browser not found'], 404);
}

try {
    $conn->beginTransaction();

    $stmt = $conn->prepare("INSERT INTO email_accounts (browser_id, email, email_password, app_password, imap_enabled, backup_codes, phone_number) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $input['browser_id'],
        $input['email'],
        $input['email_password'],
        isset($input['app_password']) ? $input['app_password'] : null,
        isset($input['imap_enabled']) ? (int)$input['imap_enabled'] : 0,
        isset($input['backup_codes']) ? $input['backup_codes'] : null,
        isset($input['phone_number']) ? $input['phone_number'] : null
    ]);
    
    $emailId = $conn->lastInsertId();

    // Automatically create Console for this email
    $console_name = isset($input['console_name']) ? $input['console_name'] : null;
    $stmt = $conn->prepare("INSERT INTO consoles (email_id, status, console_name) VALUES (?, 'review', ?)");
    $stmt->execute([$emailId, $console_name]);
    $consoleId = $conn->lastInsertId();

    $conn->commit();

    logActivity($conn, authenticate()['user_id'], 'created_email_account', 'email_account', $emailId);
    logActivity($conn, authenticate()['user_id'], 'created_console', 'console', $consoleId);

    sendResponse(['message' => 'Email account and Console created successfully', 'id' => $emailId, 'console_id' => $consoleId], 201);
} catch (Exception $e) {
    $conn->rollBack();
    sendResponse(['error' => 'Failed to create email account: ' . $e->getMessage()], 500);
}
?>
