<?php
// Delete Email Account
if (!$id) {
    sendResponse(['error' => 'Email ID is required'], 400);
}

$conn = getDBConnection();

try {
    // Console will be deleted automatically due to ON DELETE CASCADE
    $stmt = $conn->prepare("DELETE FROM email_accounts WHERE id = ?");
    $stmt->execute([$id]);

    if ($stmt->rowCount() > 0) {
        logActivity($conn, authenticate()['user_id'], 'deleted_email_account', 'email_account', $id);
        sendResponse(['message' => 'Email account deleted successfully']);
    } else {
        sendResponse(['error' => 'Email account not found'], 404);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to delete email account: ' . $e->getMessage()], 500);
}
?>
