<?php
// Fetch Actual Gmail Messages via IMAP
$conn = getDBConnection();

if (!$id) {
    sendResponse(['error' => 'Email ID is required'], 400);
}

try {
    // 1. Fetch account credentials from DB
    $stmt = $conn->prepare("SELECT email, email_password, app_password, last_msg_count FROM email_accounts WHERE id = ?");
    $stmt->execute([$id]);
    $account = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$account) {
        sendResponse(['error' => 'Email account not found'], 404);
    }

    $email = $account['email'];
    // Use App Password if available, otherwise fallback to main password
    $password = !empty($account['app_password']) ? $account['app_password'] : $account['email_password'];

    // Gmail IMAP Configuration
    $server = '{imap.gmail.com:993/imap/ssl}INBOX';
    
    // Suppress warnings from imap_open to handle errors gracefully
    $imap = @imap_open($server, $email, $password, OP_READONLY, 1, ['DISABLE_AUTHENTICATOR' => 'GSSAPI']);

    if (!$imap) {
        $error = imap_last_error();
        sendResponse([
            'error' => 'Failed to connect to Gmail: ' . $error,
            'hint' => 'Make sure "IMAP" is enabled in your Gmail settings and use an "App Password" if you have 2FA enabled.'
        ], 401);
    }

    // 2. Fetch last 15 emails
    $totalMessages = imap_num_msg($imap);
    
    // Reset "has_new_mail" flag because the user is viewing it now
    $stmt = $conn->prepare("UPDATE email_accounts SET has_new_mail = 0, last_msg_count = ? WHERE id = ?");
    $stmt->execute([$totalMessages, $id]);

    $messages = [];
    
    $fetchCount = 15;
    $start = max(1, $totalMessages - $fetchCount + 1);
    
    for ($i = $totalMessages; $i >= $start; $i--) {
        $header = imap_headerinfo($imap, $i);
        $structure = imap_fetchstructure($imap, $i);
        
        // Get Subject (decode if necessary)
        $subject = isset($header->subject) ? imap_utf8($header->subject) : '(No Subject)';
        $from = isset($header->fromaddress) ? $header->fromaddress : '(Unknown Sender)';
        $date = isset($header->date) ? date('Y-m-d H:i:s', strtotime($header->date)) : '(No Date)';
        
        // Brief preview of the body (fetch snippet)
        $body = @imap_fetchbody($imap, $i, 1.1); // Try to get plain text part
        if (!$body) {
            $body = @imap_fetchbody($imap, $i, 1); // Fallback to first part
        }
        
        // Simple sanitization for preview
        $preview = mb_strimwidth(strip_tags((string)$body), 0, 150, "...");

        $messages[] = [
            'msg_id' => $i,
            'subject' => $subject,
            'from' => $from,
            'date' => $date,
            'preview' => $preview
        ];
    }

    imap_close($imap);

    sendResponse([
        'email' => $email,
        'total_inbox' => $totalMessages,
        'messages' => $messages
    ]);

} catch (Exception $e) {
    sendResponse(['error' => 'Inbox fetch error: ' . $e->getMessage()], 500);
}
?>
