<?php
// List Email Accounts
$conn = getDBConnection();

$browser_id = isset($_GET['browser_id']) ? $_GET['browser_id'] : null;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
if ($page < 1) $page = 1;
if ($limit < 1) $limit = 20;
$offset = ($page - 1) * $limit;

$statusColors = [
    'terminated' => 'red',
    'sold' => 'green',
    'ready' => 'green',
    'review' => 'yellow',
    'document_pending' => 'yellow',
    'document_review' => 'yellow'
];

try {
    if ($id) {
        // Get single email
        $stmt = $conn->prepare("SELECT e.*, c.status FROM email_accounts e LEFT JOIN consoles c ON e.id = c.email_id WHERE e.id = ?");
        $stmt->execute([$id]);
        $email = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($email) {
            $email['status_color'] = $statusColors[$email['status'] ?? 'review'] ?? 'gray';
            sendResponse($email);
        } else {
            sendResponse(['error' => 'Email account not found'], 404);
        }
    } else {
        // List with filters and pagination
        $rdp_id = isset($_GET['rdp_id']) ? $_GET['rdp_id'] : null;
        $search = isset($_GET['search']) ? trim($_GET['search']) : null;
        
        $sql = "SELECT e.*, c.status, c.console_name, b.rdp_id 
                FROM email_accounts e 
                LEFT JOIN consoles c ON e.id = c.email_id
                JOIN browsers b ON e.browser_id = b.id";
        
        $countSql = "SELECT COUNT(*) 
                     FROM email_accounts e 
                     JOIN browsers b ON e.browser_id = b.id
                     LEFT JOIN consoles c ON e.id = c.email_id";
        
        $params = [];
        $where = [];

        if ($browser_id) {
            $where[] = "e.browser_id = ?";
            $params[] = $browser_id;
        }

        if ($rdp_id) {
            $where[] = "b.rdp_id = ?";
            $params[] = $rdp_id;
        }

        if ($search) {
            $where[] = "(e.email LIKE ? OR e.phone_number LIKE ? OR c.console_name LIKE ?)";
            $params[] = "%$search%";
            $params[] = "%$search%";
            $params[] = "%$search%";
        }

        if (!empty($where)) {
            $sql .= " WHERE " . implode(" AND ", $where);
            $countSql .= " WHERE " . implode(" AND ", $where);
        }

        // Get total count for pagination metadata
        $stmtCount = $conn->prepare($countSql);
        $stmtCount->execute($params);
        $totalCount = (int)$stmtCount->fetchColumn();

        // Add sorting and pagination
        // Custom Status Priority: review (1), others (2), sold (3), terminated (4)
        // Also prioritize has_new_mail = 1
        $sql .= " ORDER BY 
                  (CASE 
                    WHEN c.status = 'review' THEN 1 
                    WHEN c.status IN ('ready', 'document_pending', 'document_review') OR c.status IS NULL THEN 2
                    WHEN c.status = 'sold' THEN 3
                    WHEN c.status = 'terminated' THEN 4
                    ELSE 5 
                  END) ASC,
                  e.has_new_mail DESC,
                  e.id DESC 
                  LIMIT ? OFFSET ?";
        
        $params[] = $limit;
        $params[] = $offset;

        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $emails = $stmt->fetchAll(PDO::FETCH_ASSOC);

        foreach ($emails as &$em) {
            $em['status_color'] = $statusColors[$em['status'] ?? 'review'] ?? 'gray';
        }

        sendResponse([
            'total_count' => $totalCount,
            'page' => $page,
            'limit' => $limit,
            'total_pages' => ceil($totalCount / $limit),
            'data' => $emails
        ]);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch email accounts: ' . $e->getMessage()], 500);
}
?>
