<?php
// Update Email Account
if (!$id) {
    sendResponse(['error' => 'Email ID is required'], 400);
}

$input = getInput();
if (!$input) {
    sendResponse(['error' => 'No data provided'], 400);
}

$conn = getDBConnection();

$fields = [];
$params = [];

if (isset($input['email'])) {
    $fields[] = "email = ?";
    $params[] = $input['email'];
}
if (isset($input['email_password'])) {
    $fields[] = "email_password = ?";
    $params[] = $input['email_password'];
}
if (isset($input['backup_codes'])) {
    $fields[] = "backup_codes = ?";
    $params[] = $input['backup_codes'];
}
if (isset($input['phone_number'])) {
    $fields[] = "phone_number = ?";
    $params[] = $input['phone_number'];
}
if (isset($input['app_password'])) {
    $fields[] = "app_password = ?";
    $params[] = $input['app_password'];
}
if (isset($input['imap_enabled'])) {
    $fields[] = "imap_enabled = ?";
    $params[] = (int)$input['imap_enabled'];
} if (isset($input['browser_id'])) {
    $fields[] = "browser_id = ?";
    $params[] = $input['browser_id'];
}

if (empty($fields)) {
    sendResponse(['error' => 'No fields to update'], 400);
}

$params[] = $id;

try {
    $sql = "UPDATE email_accounts SET " . implode(", ", $fields) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    if ($stmt->rowCount() > 0) {
        logActivity($conn, authenticate()['user_id'], 'updated_email_account', 'email_account', $id);
        sendResponse(['message' => 'Email account updated successfully']);
    } else {
        sendResponse(['message' => 'No changes made or Email account not found']);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to update email account: ' . $e->getMessage()], 500);
}
?>
