<?php
// Helper functions

function sendResponse($data, $statusCode = 200) {
    header("Content-Type: application/json");
    http_response_code($statusCode);
    echo json_encode($data);
    exit;
}

function getInput() {
    return json_decode(file_get_contents("php://input"), true);
}

function authenticate() {
    $token = JWT::getBearerToken();
    if (!$token) {
        sendResponse(['error' => 'Unauthorized: No token provided'], 401);
    }

    $payload = JWT::decode($token);
    if (!$payload) {
        sendResponse(['error' => 'Unauthorized: Invalid token'], 401);
    }

    return $payload;
}

function updateConsoleStatus($consoleId, $conn) {
    try {
        // Check current status first
        $stmt = $conn->prepare("SELECT status FROM consoles WHERE id = ?");
        $stmt->execute([$consoleId]);
        $currentStatus = $stmt->fetchColumn();

        // Only auto-update if currently in 'review' or 'ready' state
        // If it's 'sold', 'terminated', 'document_pending', etc., do not touch it.
        if (!in_array($currentStatus, ['review', 'ready'])) {
            return;
        }

        $stmt = $conn->prepare("SELECT status FROM apps WHERE console_id = ?");
        $stmt->execute([$consoleId]);
        $apps = $stmt->fetchAll(PDO::FETCH_COLUMN);

        if (empty($apps)) {
            $status = 'review';
        } else {
            $allPublished = true;
            $anyInReview = false;

            foreach ($apps as $appStatus) {
                if ($appStatus !== 'published') {
                    $allPublished = false;
                }
                if ($appStatus === 'in_review') {
                    $anyInReview = true;
                }
            }

            if ($allPublished) {
                $status = 'ready';
            } else {
                $status = 'review'; // Covers in_review, uploaded, rejected nuances
            }
        }

        $stmt = $conn->prepare("UPDATE consoles SET status = ? WHERE id = ?");
        $stmt->execute([$status, $consoleId]);

    } catch (Exception $e) {
        // Log error or handle it smoothly? For now, we just let it fail or log.
        error_log("Failed to update console status: " . $e->getMessage());
    }
}

function logActivity($conn, $adminId, $action, $modelType, $modelId = null) {
    try {
        $stmt = $conn->prepare("INSERT INTO activity_logs (admin_id, action, model_type, model_id) VALUES (?, ?, ?, ?)");
        $stmt->execute([$adminId, $action, $modelType, $modelId]);
    } catch (Exception $e) {
        // Silently fail or log to file, don't break the API response
        error_log("Failed to log activity: " . $e->getMessage());
    }
}
?>
