<?php
// Create Note
$conn = getDBConnection();
$user = authenticate();
$adminId = $user['user_id'];

$data = getInput();

$modelType = isset($data['model_type']) ? $data['model_type'] : null;
$modelId = isset($data['model_id']) ? (int)$data['model_id'] : null;
$note = isset($data['note']) ? trim($data['note']) : null;

// Validate Input
$allowedModels = ['rdp', 'browser', 'email_account', 'console', 'app'];

if (!$modelType || !in_array($modelType, $allowedModels)) {
    sendResponse(['error' => 'Invalid model type'], 400);
}
if (!$modelId) {
    sendResponse(['error' => 'Model ID required'], 400);
}
if (!$note) {
    sendResponse(['error' => 'Note content required'], 400);
}

try {
    // Optional: Verify model exists (skipped for brevity, but good practice)
    
    $stmt = $conn->prepare("INSERT INTO notes (admin_id, model_type, model_id, note) VALUES (?, ?, ?, ?)");
    $stmt->execute([$adminId, $modelType, $modelId, $note]);
    
    sendResponse(['message' => 'Note added successfully', 'id' => $conn->lastInsertId()], 201);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to add note: ' . $e->getMessage()], 500);
}
?>
