<?php
// List Notes
$conn = getDBConnection();

$modelType = isset($_GET['model_type']) ? $_GET['model_type'] : null;
$modelId = isset($_GET['model_id']) ? (int)$_GET['model_id'] : null;

if (!$modelType || !$modelId) {
    sendResponse(['error' => 'model_type and model_id are required'], 400);
}

try {
    $stmt = $conn->prepare("SELECT n.*, a.name as admin_name FROM notes n JOIN admins a ON n.admin_id = a.id WHERE n.model_type = ? AND n.model_id = ? ORDER BY n.created_at DESC");
    $stmt->execute([$modelType, $modelId]);
    $notes = $stmt->fetchAll();
    
    sendResponse($notes);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch notes: ' . $e->getMessage()], 500);
}
?>
