<?php
// Create RDP
$input = getInput();

if (!isset($input['ip_address']) || !isset($input['username']) || !isset($input['password'])) {
    sendResponse(['error' => 'Missing required fields (ip_address, username, password)'], 400);
}

$conn = getDBConnection();

try {
    $stmt = $conn->prepare("INSERT INTO rdps (ip_address, username, password) VALUES (?, ?, ?)");
    $stmt->execute([$input['ip_address'], $input['username'], $input['password']]);
    $rdpId = $conn->lastInsertId();
    
    // Log Activity
    logActivity($conn, authenticate()['user_id'], 'created_rdp', 'rdp', $rdpId);

    sendResponse(['message' => 'RDP created successfully', 'id' => $rdpId], 201);
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to create RDP: ' . $e->getMessage()], 500);
}
?>
