<?php
// List RDPs
$conn = getDBConnection();

$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
if ($page < 1) $page = 1;
if ($limit < 1) $limit = 20;
$offset = ($page - 1) * $limit;

try {
    if ($id) {
        $stmt = $conn->prepare("SELECT * FROM rdps WHERE id = ?");
        $stmt->execute([$id]);
        $rdp = $stmt->fetch();
        if ($rdp) {
            sendResponse($rdp);
        } else {
            sendResponse(['error' => 'RDP not found'], 404);
        }
    } else {
        $search = isset($_GET['search']) ? trim($_GET['search']) : (isset($_GET['ip_address']) ? trim($_GET['ip_address']) : null);
        
        $sql = "SELECT r.*, 
                SUM(CASE WHEN c.id IS NOT NULL AND c.status != 'terminated' THEN 1 ELSE 0 END) as total_consoles,
                SUM(CASE WHEN c.id IS NOT NULL AND c.status = 'terminated' THEN 1 ELSE 0 END) as terminated_count,
                SUM(CASE WHEN c.id IS NOT NULL AND c.status != 'terminated' AND c.last_check_at >= (NOW() - INTERVAL 5 HOUR) THEN 1 ELSE 0 END) as checked_count
                FROM rdps r
                LEFT JOIN browsers b ON b.rdp_id = r.id
                LEFT JOIN email_accounts e ON e.browser_id = b.id
                LEFT JOIN consoles c ON c.email_id = e.id";
        
        $countSql = "SELECT COUNT(*) FROM rdps r";
        
        $params = [];
        $where = [];

        if ($search) {
            $where[] = "r.ip_address LIKE ?";
            $params[] = "%$search%";
        }

        if (!empty($where)) {
            $sql .= " WHERE " . implode(" AND ", $where);
            $countSql .= " WHERE " . implode(" AND ", $where);
        }

        // Get total count of RDPs
        $stmtCount = $conn->prepare($countSql);
        $stmtCount->execute($params);
        $totalCount = (int)$stmtCount->fetchColumn();

        $sql .= " GROUP BY r.id ORDER BY r.id DESC LIMIT ? OFFSET ?";
        
        // Add limit and offset to params
        $queryParams = $params;
        $queryParams[] = $limit;
        $queryParams[] = $offset;

        $stmt = $conn->prepare($sql);
        $stmt->execute($queryParams);
        $rdps = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Process status colors
        foreach ($rdps as &$rdp) {
            $rdp['total_consoles'] = (int)($rdp['total_consoles'] ?? 0);
            $rdp['terminated_count'] = (int)($rdp['terminated_count'] ?? 0);
            $rdp['checked_count'] = (int)($rdp['checked_count'] ?? 0);
            $rdp['remaining_count'] = $rdp['total_consoles'] - $rdp['checked_count'];

            if ($rdp['total_consoles'] === 0) {
                $rdp['status_color'] = 'green';
            } elseif ($rdp['remaining_count'] === 0) {
                $rdp['status_color'] = 'green';
            } elseif ($rdp['checked_count'] > 0) {
                $rdp['status_color'] = 'yellow';
            } else {
                $rdp['status_color'] = 'red';
            }
        }

        sendResponse([
            'total_count' => $totalCount,
            'page' => $page,
            'limit' => $limit,
            'total_pages' => ceil($totalCount / $limit),
            'data' => $rdps
        ]);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch RDPs: ' . $e->getMessage()], 500);
}
?>
