<?php
// Update RDP
if (!$id) {
    sendResponse(['error' => 'RDP ID is required'], 400);
}

$input = getInput();
if (!$input) {
    sendResponse(['error' => 'No data provided'], 400);
}

$conn = getDBConnection();

// Build dynamic update query
$fields = [];
$params = [];

if (isset($input['ip_address'])) {
    $fields[] = "ip_address = ?";
    $params[] = $input['ip_address'];
}
if (isset($input['username'])) {
    $fields[] = "username = ?";
    $params[] = $input['username'];
}
if (isset($input['password'])) {
    $fields[] = "password = ?";
    $params[] = $input['password'];
}

if (empty($fields)) {
    sendResponse(['error' => 'No fields to update'], 400);
}

$params[] = $id;

try {
    $sql = "UPDATE rdps SET " . implode(", ", $fields) . " WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute($params);

    if ($stmt->rowCount() > 0) {
        logActivity($conn, authenticate()['user_id'], 'updated_rdp', 'rdp', $id);
        sendResponse(['message' => 'RDP updated successfully']);
    } else {
        sendResponse(['message' => 'No changes made or RDP not found']);
    }
} catch (Exception $e) {
    sendResponse(['error' => 'Failed to update RDP: ' . $e->getMessage()], 500);
}
?>
