<?php
// System Growth Report (Daily, Weekly, Monthly)
$conn = getDBConnection();

try {
    $report = [];

    // 1. RDP Counts
    $report['rdps'] = [
        'today' => $conn->query("SELECT COUNT(*) FROM rdps WHERE DATE(created_at) = CURDATE()")->fetchColumn(),
        'this_week' => $conn->query("SELECT COUNT(*) FROM rdps WHERE created_at >= (NOW() - INTERVAL 7 DAY)")->fetchColumn(),
        'this_month' => $conn->query("SELECT COUNT(*) FROM rdps WHERE created_at >= (NOW() - INTERVAL 30 DAY)")->fetchColumn()
    ];

    // 2. Console Counts
    $report['consoles'] = [
        'today' => $conn->query("SELECT COUNT(*) FROM consoles WHERE DATE(created_at) = CURDATE()")->fetchColumn(),
        'this_week' => $conn->query("SELECT COUNT(*) FROM consoles WHERE created_at >= (NOW() - INTERVAL 7 DAY)")->fetchColumn(),
        'this_month' => $conn->query("SELECT COUNT(*) FROM consoles WHERE created_at >= (NOW() - INTERVAL 30 DAY)")->fetchColumn()
    ];

    // 3. Email Counts
    $report['emails'] = [
        'today' => $conn->query("SELECT COUNT(*) FROM email_accounts WHERE DATE(created_at) = CURDATE()")->fetchColumn(),
        'this_week' => $conn->query("SELECT COUNT(*) FROM email_accounts WHERE created_at >= (NOW() - INTERVAL 7 DAY)")->fetchColumn(),
        'this_month' => $conn->query("SELECT COUNT(*) FROM email_accounts WHERE created_at >= (NOW() - INTERVAL 30 DAY)")->fetchColumn()
    ];

    // 4. App Counts (ZIP Uploads)
    $report['apps'] = [
        'today' => $conn->query("SELECT COUNT(*) FROM apps WHERE DATE(created_at) = CURDATE()")->fetchColumn(),
        'this_week' => $conn->query("SELECT COUNT(*) FROM apps WHERE created_at >= (NOW() - INTERVAL 7 DAY)")->fetchColumn(),
        'this_month' => $conn->query("SELECT COUNT(*) FROM apps WHERE created_at >= (NOW() - INTERVAL 30 DAY)")->fetchColumn()
    ];

    sendResponse($report);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to generate growth report: ' . $e->getMessage()], 500);
}
?>
