<?php
// Get System Stats
$conn = getDBConnection();

try {
    $stats = [];

    // 1. Total Counts
    // 1. Total Active Counts (Excluding Terminated & Sold)
    $stats['total_rdps'] = $conn->query("SELECT COUNT(*) FROM rdps")->fetchColumn();
    
    $stats['total_browsers'] = $conn->query("SELECT COUNT(*) FROM browsers b 
        LEFT JOIN email_accounts e ON b.id = e.browser_id 
        LEFT JOIN consoles c ON e.id = c.email_id 
        WHERE c.status IS NULL OR (c.status != 'terminated' AND c.status != 'sold')")->fetchColumn();
    
    $stats['total_emails'] = $conn->query("SELECT COUNT(*) FROM email_accounts e 
        LEFT JOIN consoles c ON e.id = c.email_id 
        WHERE c.status IS NULL OR (c.status != 'terminated' AND c.status != 'sold')")->fetchColumn();
    
    $stats['total_consoles'] = $conn->query("SELECT COUNT(*) FROM consoles WHERE status != 'terminated' AND status != 'sold'")->fetchColumn();
    
    $stats['total_apps'] = $conn->query("SELECT COUNT(*) FROM apps a 
        JOIN consoles c ON a.console_id = c.id 
        WHERE c.status != 'terminated' AND c.status != 'sold'")->fetchColumn();

    // 2. Console Status Breakdown
    $stmt = $conn->query("SELECT status, COUNT(*) as count FROM consoles GROUP BY status");
    $stats['consoles_by_status'] = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    // 3. App Status Breakdown
    $stmt = $conn->query("SELECT status, COUNT(*) as count FROM apps GROUP BY status");
    $stats['apps_by_status'] = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    // 4. Recent Activity (Last 5)
    $stmt = $conn->query("SELECT l.*, a.name as admin_name FROM activity_logs l LEFT JOIN admins a ON l.admin_id = a.id ORDER BY l.id DESC LIMIT 5");
    $stats['recent_activity'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 5. Attention Required: Consoles not checked for > 5 hours
    $sql = "SELECT c.id, c.console_name, c.email_id, c.status, c.last_check_at, e.email, r.ip_address, b.browser_name 
            FROM consoles c 
            JOIN email_accounts e ON c.email_id = e.id 
            JOIN browsers b ON e.browser_id = b.id 
            JOIN rdps r ON b.rdp_id = r.id 
            WHERE (c.last_check_at IS NULL OR c.last_check_at < (NOW() - INTERVAL 5 HOUR)) 
            AND c.status != 'terminated' AND c.status != 'sold'";
    
    $stmt = $conn->query($sql);
    $attention_needed = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $statusColors = [
        'terminated' => 'red',
        'sold' => 'green',
        'ready' => 'green',
        'review' => 'yellow',
        'document_pending' => 'yellow',
        'document_review' => 'yellow'
    ];

    foreach ($attention_needed as &$item) {
        $item['status_color'] = $statusColors[$item['status']] ?? 'gray';
    }
    
    $stats['attention_required_count'] = count($attention_needed);
    $stats['attention_required_list'] = $attention_needed;

    sendResponse($stats);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch stats: ' . $e->getMessage()], 500);
}
?>
