<?php
// Terminated Console Report
$conn = getDBConnection();

try {
    // 1. Fetch all terminated consoles with details
    $sql = "SELECT c.id, c.console_name, c.email_id, e.email, b.browser_name, r.ip_address, c.created_at, 
            (SELECT l.created_at FROM activity_logs l WHERE l.model_id = c.id AND l.model_type = 'console' AND l.action = 'updated_console_status' ORDER BY l.id DESC LIMIT 1) as status_updated_at
            FROM consoles c 
            JOIN email_accounts e ON c.email_id = e.id 
            JOIN browsers b ON e.browser_id = b.id 
            JOIN rdps r ON b.rdp_id = r.id 
            WHERE c.status = 'terminated'
            ORDER BY status_updated_at DESC";
    
    $stmt = $conn->query($sql);
    $terminated_list = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // If status_updated_at is null, it means it was terminated without a log entry (manual DB change), 
    // so we'll fallback to showing '-' or similar.
    
    $report = [
        'count' => count($terminated_list),
        'consoles' => $terminated_list
    ];

    sendResponse($report);

} catch (Exception $e) {
    sendResponse(['error' => 'Failed to fetch terminated console report: ' . $e->getMessage()], 500);
}
?>
