<?php
// CRON: Check App Status
// Run this script every 3 hours via cPanel or crontab

// Adjust paths as necessary based on where this file is located relative to config
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../api/helpers.php';

$conn = getDBConnection();

// System Admin ID (Use ID 1 or fetch a specific system user)
// For now, we'll try to find an admin or default to 1. 
// Ideally, creating a specific 'System' admin is better.
$systemAdminId = 1; 

echo "Starting App Status Check [" . date('Y-m-d H:i:s') . "]\n";

try {
    // 1. Fetch apps in 'in_review' with a link
    $stmt = $conn->prepare("SELECT id, console_id, app_name, app_link FROM apps WHERE status = 'in_review' AND app_link IS NOT NULL AND app_link != ''");
    $stmt->execute();
    $apps = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Found " . count($apps) . " apps in review.\n";

    foreach ($apps as $app) {
        $url = $app['app_link'];
        echo "Checking App ID {$app['id']} ({$app['app_name']}) URL: $url ... ";

        // 2. Check URL Availability
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true); // Head request usually enough, but some stores might block HEAD
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10); // 10 seconds timeout
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; AppStatusBot/1.0)');
        curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode >= 200 && $httpCode < 400) {
            echo "LIVE (HTTP $httpCode). Updating status...\n";

            // 3. Update Status to 'published'
            $updateStmt = $conn->prepare("UPDATE apps SET status = 'published' WHERE id = ?");
            $updateStmt->execute([$app['id']]);

            // 4. Update Console Status
            updateConsoleStatus($app['console_id'], $conn);

            // 5. Log Activity
            logActivity($conn, $systemAdminId, 'system_published_app', 'app', $app['id']);

        } else {
            echo "OFFLINE (HTTP $httpCode). Skipping.\n";
        }
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

echo "Done.\n";
?>
