<?php
// CRON: Check all Gmail accounts for new emails
require_once __DIR__ . '/../config/database.php';

$conn = getDBConnection();

// Fetch all accounts where IMAP is enabled
$sql = "SELECT id, email, email_password, app_password, last_msg_count FROM email_accounts WHERE imap_enabled = 1";
$stmt = $conn->query($sql);
$accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Starting email check for " . count($accounts) . " accounts...\n";

foreach ($accounts as $account) {
    $id = $account['id'];
    $email = $account['email'];
    $password = !empty($account['app_password']) ? $account['app_password'] : $account['email_password'];
    $old_count = (int)$account['last_msg_count'];

    echo "Checking $email... ";

    $server = '{imap.gmail.com:993/imap/ssl}INBOX';
    
    // Attempt connection with 10s timeout
    $imap = @imap_open($server, $email, $password, OP_READONLY, 1, ['DISABLE_AUTHENTICATOR' => 'GSSAPI']);

    if (!$imap) {
        echo "FAIL: " . imap_last_error() . "\n";
        continue;
    }

    $current_count = imap_num_msg($imap);
    imap_close($imap);

    if ($current_count > $old_count) {
        // New mail arrived!
        $update = $conn->prepare("UPDATE email_accounts SET has_new_mail = 1, last_msg_count = ? WHERE id = ?");
        $update->execute([$current_count, $id]);
        echo "NEW MAIL DETECTED ($current_count messages)\n";
    } else if ($current_count < $old_count) {
        // Mail was deleted, just update the count so we don't trigger false positives later
        $update = $conn->prepare("UPDATE email_accounts SET last_msg_count = ? WHERE id = ?");
        $update->execute([$current_count, $id]);
        echo "Mail deleted, count updated to $current_count\n";
    } else {
        echo "No new mail.\n";
    }
}

echo "Check complete.\n";
?>
