
-- Drop columns if they exist to start fresh or alter if needed
-- But simpler: Just add columns if not exist. 
-- Since we know it failed, likely columns might not be there or partial failure.

-- Let's try separate statements:

SET FOREIGN_KEY_CHECKS=0;

ALTER TABLE `consoles` ADD COLUMN `last_check_at` TIMESTAMP NULL DEFAULT NULL;
ALTER TABLE `consoles` ADD COLUMN `last_check_by` INT(11) NULL DEFAULT NULL;

-- Add index first for performance and FK requirement
ALTER TABLE `consoles` ADD INDEX `idx_last_check_by` (`last_check_by`);

-- Now add FK
ALTER TABLE `consoles` ADD CONSTRAINT `fk_consoles_last_check_by` FOREIGN KEY (`last_check_by`) REFERENCES `admins`(`id`) ON DELETE SET NULL;

SET FOREIGN_KEY_CHECKS=1;
