
CREATE TABLE IF NOT EXISTS `notes` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `admin_id` INT NOT NULL,
    `model_type` ENUM('rdp', 'browser', 'email_account', 'console', 'app') NOT NULL,
    `model_id` INT NOT NULL,
    `note` TEXT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`admin_id`) REFERENCES `admins`(`id`) ON DELETE CASCADE
);

CREATE INDEX `idx_notes_model` ON `notes` (`model_type`, `model_id`);
