<?php
// Main Entry Point

require_once '../config/database.php';
require_once '../config/jwt.php';
require_once '../api/helpers.php';

// CORS Implementation
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = explode('/', $uri);

// Remove empty elements and re-index
$uri = array_values(array_filter($uri));

// $uri[0] should be 'api' (assuming /api/resource...)
// If executed from root directly, it might differ.
// Let's dynamically find where 'api' is.

$apiIndex = array_search('api', $uri);

if ($apiIndex !== false && isset($uri[$apiIndex + 1])) {
    $resource = $uri[$apiIndex + 1];
    $id = isset($uri[$apiIndex + 2]) ? $uri[$apiIndex + 2] : null;
    $action = isset($uri[$apiIndex + 3]) ? $uri[$apiIndex + 3] : null; // For download etc
} else {
    $resource = null;
    $id = null;
    $action = null;
}

// Make globally available for other scripts if needed, or pass them down.
// For simple include scope, they are available.

// Route dispatching
switch ($resource) {
    case 'auth':
        require '../api/auth/routes.php';
        break;
    case 'rdp':
        require '../api/rdp/routes.php';
        break;
    case 'browser':
        require '../api/browser/routes.php';
        break;
    case 'email':
        require '../api/email/routes.php';
        break;
    case 'console':
        require '../api/console/routes.php';
        break;
    case 'app':
    case 'apps': // Alias for 'app' to match requirements
        require '../api/app/routes.php';
        break;
    case 'audit':
        require '../api/audit/routes.php';
        break;
    case 'stats':
        require '../api/stats/routes.php';
        break;
    case 'notes':
        require '../api/notes/routes.php';
        break;
    default:
        sendResponse(['error' => 'Endpoint not found: ' . $resource], 404);
        break;
}
?>
