<?php
// Verification Script

$baseUrl = 'https://consoleapi.inficomsolutions.in/api';
$email = 'admin' . time() . '@test.com';
$password = 'password123';
$token = '';

function callAPI($method, $url, $data = [], $headers = []) {
    $curl = curl_init();
    
    $options = [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => array_merge(['Content-Type: application/json'], $headers),
        CURLOPT_HEADER => true, // To capture headers
    ];

    if (!empty($data)) {
        if ($method === 'POST' && isset($data['multipart'])) {
             // Handle multipart
             unset($options[CURLOPT_HTTPHEADER][0]); // Remove Content-Type: application/json
             $postFields = $data['fields'];
             if (isset($data['files'])) {
                 foreach ($data['files'] as $key => $path) {
                     $postFields[$key] = new CURLFile($path);
                 }
             }
             $options[CURLOPT_POSTFIELDS] = $postFields;
        } else {
            $options[CURLOPT_POSTFIELDS] = json_encode($data);
        }
    }

    curl_setopt_array($curl, $options);
    
    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
    $responseHeader = substr($response, 0, $headerSize);
    $responseBody = substr($response, $headerSize);
    
    curl_close($curl);
    
    return ['code' => $httpCode, 'body' => json_decode($responseBody, true), 'raw_body' => $responseBody];
}

// 1. Register
echo "1. Registering Admin...\n";
$res = callAPI('POST', "$baseUrl/auth/register", ['name' => 'Admin', 'email' => $email, 'password' => $password]);
if ($res['code'] === 201) {
    echo "SUCCESS: Registered\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
    exit;
}

// 2. Login
echo "2. Logging in...\n";
$res = callAPI('POST', "$baseUrl/auth/login", ['email' => $email, 'password' => $password]);
if ($res['code'] === 200) {
    $token = $res['body']['token'];
    echo "SUCCESS: Logged in. Token: " . substr($token, 0, 10) . "...\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
    exit;
}

$authHeader = ["Authorization: Bearer $token"];

// 3. Create RDP
echo "3. Creating RDP...\n";
$res = callAPI('POST', "$baseUrl/rdp", ['ip_address' => '1.1.1.1', 'username' => 'user', 'password' => 'pass'], $authHeader);
$rdpId = $res['body']['id'] ?? null;
if ($res['code'] === 201) {
    echo "SUCCESS: RDP Created (ID: $rdpId)\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
    exit;
}

// 4. Create Browser
echo "4. Creating Browser...\n";
$res = callAPI('POST', "$baseUrl/browser", ['rdp_id' => $rdpId, 'browser_name' => 'Chrome 1'], $authHeader);
$browserId = $res['body']['id'] ?? null;
if ($res['code'] === 201) {
    echo "SUCCESS: Browser Created (ID: $browserId)\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
    exit;
}

// 5. Create Email Account (and check Console)
echo "5. Creating Email Account...\n";
$res = callAPI('POST', "$baseUrl/email", ['browser_id' => $browserId, 'email' => 'test@email.com', 'email_password' => 'pass', 'phone_number' => '123'], $authHeader);
$emailId = $res['body']['id'] ?? null;
$consoleId = $res['body']['console_id'] ?? null;
if ($res['code'] === 201 && $consoleId) {
    echo "SUCCESS: Email & Console Created (Email ID: $emailId, Console ID: $consoleId)\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
    exit;
}

// 6. Create App (Multipart)
echo "6. Creating App (Multipart)...\n";
// Create dummy files
file_put_contents('dummy.zip', 'PK...'); 
file_put_contents('dummy.jks', 'dummy jks content');

$appData = [
    'multipart' => true,
    'fields' => [
        'console_id' => $consoleId,
        'app_name' => 'Test App'
    ],
    'files' => [
        'app_code_zip' => realpath('dummy.zip'),
        'jks_file' => realpath('dummy.jks')
    ]
];

$res = callAPI('POST', "$baseUrl/app", $appData, $authHeader);
$appId = $res['body']['id'] ?? null;
if ($res['code'] === 201) {
    echo "SUCCESS: App Created (ID: $appId)\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
    exit;
}

// 7. Check Console Status (Initial)
echo "7. Checking Console Status (Should be 'review')...\n";
$res = callAPI('GET', "$baseUrl/console/$consoleId", [], $authHeader);
$status = $res['body']['status'] ?? null;
if ($status === 'review') {
    echo "SUCCESS: Console Status is '$status'\n";
} else {
    echo "FAILED: Console Status is '$status' (Expected 'review')\n";
}

// 8. Update App Status to Published
echo "8. Updating App Status to 'published'...\n";
$res = callAPI('PUT', "$baseUrl/app/$appId", ['status' => 'published'], $authHeader);
if ($res['code'] === 200) {
    echo "SUCCESS: App Updated\n";
} else {
    echo "FAILED: " . print_r($res, true) . "\n";
}

// 9. Check Console Status (Should be 'ready')
echo "9. Checking Console Status (Should be 'ready')...\n";
$res = callAPI('GET', "$baseUrl/console/$consoleId", [], $authHeader);
$status = $res['body']['status'] ?? null;
if ($status === 'ready') {
    echo "SUCCESS: Console Status is '$status'\n";
} else {
    echo "FAILED: Console Status is '$status' (Expected 'ready')\n";
}

// 10. Test Download
echo "10. Testing Download API...\n";
$downloadUrl = "$baseUrl/apps/$appId/download";
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $downloadUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $authHeader
]);
$fileContent = curl_exec($curl);
$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
curl_close($curl);

if ($httpCode === 200 && strlen($fileContent) > 0) {
    echo "SUCCESS: Downloaded file (Size: " . strlen($fileContent) . " bytes)\n";
} else {
    echo "FAILED: HTTP $httpCode\n";
}

// Clean up dummy files
unlink('dummy.zip');
unlink('dummy.jks');
?>
