#!/bin/bash

BASE_URL="https://consoleapi.inficomsolutions.in/public/api" 

EMAIL="admin$(date +%s)@test.com"
PASSWORD="password123"

echo "Using Base URL: $BASE_URL"

echo "1. Registering Admin ($EMAIL)..."
curl -s -X POST "$BASE_URL/auth/register" \
  -H "Content-Type: application/json" \
  -d "{\"name\":\"Admin\", \"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}"
echo ""

echo "2. Logging in..."
LOGIN_RES=$(curl -s -X POST "$BASE_URL/auth/login" \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}")

TOKEN=$(echo $LOGIN_RES | grep -o '"token":"[^"]*' | cut -d'"' -f4)

if [ -z "$TOKEN" ]; then
  echo "FAILED: No token received. Response: $LOGIN_RES"
  exit 1
fi
echo "SUCCESS: Token received: ${TOKEN:0:10}..."

echo "3. Creating RDP..."
RDP_RES=$(curl -s -X POST "$BASE_URL/rdp" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"ip_address":"1.1.1.1", "username":"user", "password":"password"}')
RDP_ID=$(echo $RDP_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')
echo "RDP ID: $RDP_ID"

if [ -z "$RDP_ID" ]; then
    echo "Failed to create RDP: $RDP_RES"
    exit 1
fi

echo "4. Creating Browser..."
BROWSER_RES=$(curl -s -X POST "$BASE_URL/browser" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d "{\"rdp_id\":$RDP_ID, \"browser_name\":\"Chrome 1\"}")
BROWSER_ID=$(echo $BROWSER_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')
echo "Browser ID: $BROWSER_ID"

echo "5. Creating Email Account..."
EMAIL_RES=$(curl -s -X POST "$BASE_URL/email" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d "{\"browser_id\":$BROWSER_ID, \"email\":\"test@email.com\", \"email_password\":\"pass\"}")
EMAIL_ID=$(echo $EMAIL_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')
CONSOLE_ID=$(echo $EMAIL_RES | grep -o '"console_id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')
echo "Email ID: $EMAIL_ID, Console ID: $CONSOLE_ID"

echo "6. Creating App..."
# Create dummy files
echo "PK..." > dummy.zip
echo "dummy jks" > dummy.jks

APP_RES=$(curl -s -X POST "$BASE_URL/app" \
  -H "Authorization: Bearer $TOKEN" \
  -F "console_id=$CONSOLE_ID" \
  -F "app_name=Test App" \
  -F "app_code_zip=@dummy.zip" \
  -F "jks_file=@dummy.jks")
APP_ID=$(echo $APP_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')
echo "App ID: $APP_ID"

# Clean up
rm dummy.zip dummy.jks

if [ -z "$APP_ID" ]; then
    echo "Failed to create App: $APP_RES"
    exit 1
fi

echo "7. Checking Console Status (Should be 'review')..."
STATUS_RES=$(curl -s -X GET "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN")
STATUS=$(echo $STATUS_RES | grep -o '"status":"[^"]*' | cut -d'"' -f4)
echo "Console Status: $STATUS"

echo "8. Updating App Status to 'published'..."
curl -s -X PUT "$BASE_URL/app/$APP_ID" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"status":"published"}'
echo ""

echo "9. Checking Console Status (Should be 'ready')..."
STATUS_RES=$(curl -s -X GET "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN")
STATUS=$(echo $STATUS_RES | grep -o '"status":"[^"]*' | cut -d'"' -f4)
echo "Console Status: $STATUS"

echo "10. Testing Download..."
HTTP_CODE=$(curl -s -o /dev/null -w "%{http_code}" -X GET "$BASE_URL/apps/$APP_ID/download" -H "Authorization: Bearer $TOKEN")
echo "Download HTTP Code: $HTTP_CODE"

exit 0
