#!/bin/bash

BASE_URL="https://consoleapi.inficomsolutions.in/public/api" 

# reuse known admin credentials or create new
EMAIL="admin$(date +%s)@test.com"
PASSWORD="password123"

echo "1. Registering Admin..."
curl -s -X POST "$BASE_URL/auth/register" \
  -H "Content-Type: application/json" \
  -d "{\"name\":\"Admin\", \"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}" > /dev/null

echo "2. Logging in..."
LOGIN_RES=$(curl -s -X POST "$BASE_URL/auth/login" \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}")

TOKEN=$(echo $LOGIN_RES | grep -o '"token":"[^"]*' | cut -d'"' -f4)

if [ -z "$TOKEN" ]; then
  echo "FAILED: No token received."
  exit 1
fi

echo "3. Creating RDP (to generate log)..."
curl -s -X POST "$BASE_URL/rdp" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"ip_address":"1.1.1.1", "username":"user", "password":"password"}' > /dev/null

echo "4. Fetching Audit Logs..."
LOGS=$(curl -s -X GET "$BASE_URL/audit" \
  -H "Authorization: Bearer $TOKEN")

echo "$LOGS"
