#!/bin/bash

BASE_URL="https://consoleapi.inficomsolutions.in/public/api" 

# reuse known admin credentials or create new
EMAIL="admin$(date +%s)@test.com"
PASSWORD="password123"

# Register & Login
curl -s -X POST "$BASE_URL/auth/register" -H "Content-Type: application/json" -d "{\"name\":\"Admin Check\", \"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}" > /dev/null
LOGIN_RES=$(curl -s -X POST "$BASE_URL/auth/login" -H "Content-Type: application/json" -d "{\"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}")
TOKEN=$(echo $LOGIN_RES | grep -o '"token":"[^"]*' | cut -d'"' -f4)

if [ -z "$TOKEN" ]; then
  echo "FAILED: No token."
  exit 1
fi

# Create RDP -> Browser -> Email -> Console
RDP_RES=$(curl -s -X POST "$BASE_URL/rdp" -H "Authorization: Bearer $TOKEN" -H "Content-Type: application/json" -d '{"ip_address":"1.1.1.1", "username":"u", "password":"p"}')
RDP_ID=$(echo $RDP_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

BROWSER_RES=$(curl -s -X POST "$BASE_URL/browser" -H "Authorization: Bearer $TOKEN" -H "Content-Type: application/json" -d "{\"rdp_id\":$RDP_ID, \"browser_name\":\"B1\"}")
BROWSER_ID=$(echo $BROWSER_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

EMAIL_RES=$(curl -s -X POST "$BASE_URL/email" -H "Authorization: Bearer $TOKEN" -H "Content-Type: application/json" -d "{\"browser_id\":$BROWSER_ID, \"email\":\"e@e.com\", \"email_password\":\"p\"}")
CONSOLE_ID=$(echo $EMAIL_RES | grep -o '"console_id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

echo "Console Created: $CONSOLE_ID"

# Check Console
echo "Checking Console..."
CHECK_RES=$(curl -s -X POST "$BASE_URL/console/$CONSOLE_ID/check" \
  -H "Authorization: Bearer $TOKEN")
echo "Check Response: $CHECK_RES"

# Verify
echo "Verifying Check Status..."
CONSOLE_DATA=$(curl -s -X GET "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN")

LAST_CHECK_BY=$(echo $CONSOLE_DATA | grep -o '"last_checked_by_name":"[^"]*' | cut -d'"' -f4)

echo "Last Checked By: $LAST_CHECK_BY"

if [ "$LAST_CHECK_BY" == "Admin Check" ]; then
    echo "SUCCESS: Console check verified."
else
    echo "FAILED: Last checked by name not found or incorrect."
    exit 1
fi
