#!/bin/bash

BASE_URL="https://consoleapi.inficomsolutions.in/public/api" 

# reuse known admin credentials or create new
EMAIL="admin$(date +%s)@test.com"
PASSWORD="password123"

# Register & Login
curl -s -X POST "$BASE_URL/auth/register" -H "Content-Type: application/json" -d "{\"name\":\"Stats Checker\", \"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}" > /dev/null
LOGIN_RES=$(curl -s -X POST "$BASE_URL/auth/login" -H "Content-Type: application/json" -d "{\"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}")
TOKEN=$(echo $LOGIN_RES | grep -o '"token":"[^"]*' | cut -d'"' -f4)

if [ -z "$TOKEN" ]; then
  echo "FAILED: No token."
  exit 1
fi

echo "Fetching Stats..."
STATS_RES=$(curl -s -X GET "$BASE_URL/stats" \
  -H "Authorization: Bearer $TOKEN")

echo "$STATS_RES"

# Check if response contains expected keys
if [[ $STATS_RES == *"total_consoles"* ]]; then
    echo "SUCCESS: Stats API verified."
else
    echo "FAILED: Stats API missing data."
    exit 1
fi
