#!/bin/bash

BASE_URL="https://consoleapi.inficomsolutions.in/public/api" 

# reuse known admin credentials or create new
EMAIL="admin$(date +%s)@test.com"
PASSWORD="password123"

# Register & Login
curl -s -X POST "$BASE_URL/auth/register" -H "Content-Type: application/json" -d "{\"name\":\"Status Checker\", \"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}" > /dev/null
LOGIN_RES=$(curl -s -X POST "$BASE_URL/auth/login" -H "Content-Type: application/json" -d "{\"email\":\"$EMAIL\", \"password\":\"$PASSWORD\"}")
TOKEN=$(echo $LOGIN_RES | grep -o '"token":"[^"]*' | cut -d'"' -f4)

if [ -z "$TOKEN" ]; then
  echo "FAILED: No token."
  exit 1
fi

# Create RDP -> Browser -> Email -> Console
RDP_RES=$(curl -s -X POST "$BASE_URL/rdp" -H "Authorization: Bearer $TOKEN" -H "Content-Type: application/json" -d '{"ip_address":"2.2.2.2", "username":"u", "password":"p"}')
RDP_ID=$(echo $RDP_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

BROWSER_RES=$(curl -s -X POST "$BASE_URL/browser" -H "Authorization: Bearer $TOKEN" -H "Content-Type: application/json" -d "{\"rdp_id\":$RDP_ID, \"browser_name\":\"B2\"}")
BROWSER_ID=$(echo $BROWSER_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

EMAIL_RES=$(curl -s -X POST "$BASE_URL/email" -H "Authorization: Bearer $TOKEN" -H "Content-Type: application/json" -d "{\"browser_id\":$BROWSER_ID, \"email\":\"e2@e.com\", \"email_password\":\"p\"}")
CONSOLE_ID=$(echo $EMAIL_RES | grep -o '"console_id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

echo "Console Created: $CONSOLE_ID"

# 1. Update Console to 'document_pending'
echo "Setting Console to document_pending..."
curl -s -X PUT "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"status":"document_pending"}'

# Verify
CONSOLE_DATA=$(curl -s -X GET "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN")
STATUS=$(echo $CONSOLE_DATA | grep -o '"status":"[^"]*' | cut -d'"' -f4)
echo "Status: $STATUS"

if [ "$STATUS" != "document_pending" ]; then
    echo "FAILED: Console status update failed."
    exit 1
fi

# 2. Check Auto-Update Block
# Create App (Status: uploaded)
echo "PK..." > dummy.zip
echo "dummy jks" > dummy.jks

APP_RES=$(curl -s -X POST "$BASE_URL/app" \
  -H "Authorization: Bearer $TOKEN" \
  -F "console_id=$CONSOLE_ID" \
  -F "app_name=Status App" \
  -F "app_code_zip=@dummy.zip" \
  -F "jks_file=@dummy.jks")
APP_ID=$(echo $APP_RES | grep -o '"id":[^,}]*' | cut -d':' -f2 | tr -d ' ' | tr -d '"')

# Update App to 'published' (Should trigger auto-update, but be blocked)
echo "Updating App to published..."
curl -s -X PUT "$BASE_URL/app/$APP_ID" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"status":"published"}' > /dev/null

# Verify Console Status (Should still be document_pending)
CONSOLE_DATA=$(curl -s -X GET "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN")
STATUS=$(echo $CONSOLE_DATA | grep -o '"status":"[^"]*' | cut -d'"' -f4)
echo "Status after App Publish: $STATUS"

if [ "$STATUS" != "document_pending" ]; then
    echo "FAILED: Auto-update was not blocked."
    exit 1
fi

# 3. Reset to 'review' and check auto-update
echo "Resetting Console to review..."
curl -s -X PUT "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"status":"review"}'

# Trigger App Update again (Just re-set to published to trigger hook)
curl -s -X PUT "$BASE_URL/app/$APP_ID" \
  -H "Authorization: Bearer $TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"status":"published"}' > /dev/null

# Verify Console Status (Should be ready now)
CONSOLE_DATA=$(curl -s -X GET "$BASE_URL/console/$CONSOLE_ID" \
  -H "Authorization: Bearer $TOKEN")
STATUS=$(echo $CONSOLE_DATA | grep -o '"status":"[^"]*' | cut -d'"' -f4)
echo "Status after Reset & App Publish: $STATUS"

if [ "$STATUS" != "ready" ]; then
    echo "FAILED: Auto-update did not trigger after reset."
    exit 1
fi

echo "SUCCESS: Status Edit features verified."
